import json
from pathlib import Path

def json_to_chat_text(json_path, output_path):
    data = json.loads(Path(json_path).read_text(encoding="utf-8"))
    
    with open(output_path, "w", encoding="utf-8") as out:
        for msg in data:
            author = msg["authorName"]
            date = msg["date"]
            ref = msg["referenceMessage"]
            content = msg["content"]
            
            line = f"{author} {date}"
            if ref:
                line += f" Replying to {msg['referenceMessageAuthor']}: {ref.strip()}"
            line += f"\n{content.strip()}\n\n"
            
            out.write(line)

json_to_chat_text("data/discord_data.json", "data/chat_data.txt")
